var CB;
(function (CB) {
    var Utils;
    (function (Utils) {
        function applyRelevantPointsFromOldUnitToNew(oldUnit, newUnit) {
            var oldPoints = oldUnit.Points.keys;
            var newPoints = newUnit.Points.keys;
            for (var index = 0; index < oldPoints.length; index++) {
                var key = oldPoints[index];
                var point = oldUnit.Points.get(key);
                if (newUnit.Points.get(key)) {
                    var newPoint = newUnit.Points.get(key);
                    if (point.Current < point.Max) {
                        // if their maximum values are the same, it's a direct translation
                        if (point.Max == newPoint.Max) {
                            newPoint.Current = point.Current;
                        }
                        else {
                            var percentage = point.Current / point.Max * 100;
                            var newPointValue = Math.round(percentage * newPoint.Max / 100);
                            newPoint.Current = newPointValue;
                        }
                    }
                }
            }
        }
        Utils.applyRelevantPointsFromOldUnitToNew = applyRelevantPointsFromOldUnitToNew;
        function moveWholeInventoryBetweenUnits(giver, receiver) {
            var giverItems = giver.Inventory.Items;
            var giverEquippedItems = giver.GetEquippedItems();
            var inventory = receiver.Inventory;
            for (var index = 0; index < giverItems.length; index++) {
                var item = giverItems[index];
                if (item.ScriptFlags.get("not_transfered_on_transform") == true)
                    continue;
                receiver.Inventory.Add(item);
            }
            for (var index = 0; index < giverEquippedItems.length; index++) {
                var item = giverEquippedItems[index];
                if (item.ScriptFlags.get("not_transfered_on_transform") == true)
                    continue;
                receiver.Inventory.Add(item);
            }
        }
        Utils.moveWholeInventoryBetweenUnits = moveWholeInventoryBetweenUnits;
    })(Utils = CB.Utils || (CB.Utils = {}));
})(CB || (CB = {}));
